# Dark Theme

## Description

A comprehensive dark theme for Matomo Analytics that transforms the entire interface into a modern, eye-friendly dark experience. Built with accessibility and readability in mind, this theme provides proper contrast ratios and consistent styling across all Matomo features.

### Key Features

- **Complete UI Coverage** - Every screen, widget, modal, and component is styled for dark mode
- **Charts & Graphs** - All jqPlot charts (sparklines, bar graphs, pie charts, evolution graphs) render beautifully with dark backgrounds and vibrant data colors
- **Maps Support** - RealTimeMap and UserCountryMap fully themed with appropriate color scales for data visualization
- **Consistent Design** - Cards, widgets, sidebar navigation, and modals all share a cohesive dark aesthetic
- **CSS Variables** - Built with native CSS custom properties for easy customization
- **Plugin Compatibility** - Works seamlessly with Matomo plugins including Funnels, Tag Manager, AI Chats, and more

### Why Choose Dark Theme?

- Reduces eye strain during extended analytics sessions
- Perfect for low-light environments and night-time work
- Professional appearance that matches modern dark-mode applications
- Actively maintained and updated with each Matomo release

### Customization

The theme uses CSS custom properties (variables) that you can override to match your brand colors. All styling is done through LESS files organized into maintainable components.

**Thank you for installing!**

## Support

If you encounter any issues or have suggestions, please:
- Open an issue on [GitHub](https://github.com/openmost/DarkTheme/issues)
- Contact us at ronan@openmost.io

## Want More?

Looking for a custom theme tailored to your brand? We create bespoke Matomo themes for businesses. Visit [openmost.io](https://openmost.io) or contact us to discuss your requirements.
